﻿using System;
using System.Web.Mvc;
using SportsStore.Domain.Entities;

namespace SportsStore.WebUI.Binders
{

    public class CartModelBinder : IModelBinder
    {
        private const string sessionKey = "Cart";

        public object BindModel(ControllerContext controllerContext,
            ModelBindingContext bindingContext)
        {

            // pobranie obiektu Cart z sesji
            Cart cart = (Cart)controllerContext.HttpContext.Session[sessionKey];
            // utworzenie obiektu Cart jeżeli nie został znaleziony w danych sesji
            if (cart == null)
            {
                cart = new Cart();
                controllerContext.HttpContext.Session[sessionKey] = cart;
            }
            // zwróć koszyk
            return cart;
        }
    }
}
